---
title: "Publication - Large-Scale Intelligent Microservices"
description: "Large-Scale Intelligent Microservices"
keywords: [
	"microservices", "IEEE Big Data", "paper",
]
---

The process of deploying Machine Learning (ML) algorithms within databases is challenging. The varied computational footprints of modern ML algorithms and the myriad of database technologies, each with their own restrictive syntax, make such tasks more than a little complex. We introduce an Apache Spark-based micro-service orchestration <!--truncate--> framework that extends database operations to include web service primitives. Our system can orchestrate web services across hundreds of machines and takes full advantage of cluster, thread, and asynchronous parallelism. Using this framework, we provide large scale clients for intelligent services such as speech, vision, search, anomaly detection, and text analysis. These clients allow users to integrate ready-to-use intelligence into any datastore with an Apache Spark connector. To eliminate much of the overhead from network communication, we also introduce a low-latency containerized version of our architecture. We demonstrate that the services we investigate are competitive on several important benchmarks. Finally, we present two applications of this framework to create intelligent search engines and real-time auto race analytics systems.

[Read More](https://www.microsoft.com/en-us/research/publication/large-scale-services/)
